/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.tools.integration.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.ftbsbc.tools.recipies.CrookRecipe;
import dev.ftb.ftbsbc.tools.recipies.ItemWithChance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;

public class CrookCategory
implements IRecipeCategory<CrookRecipe> {
    public static final ResourceLocation ID = new ResourceLocation("ftbsbc", "crook_jei");
    public static final ResourceLocation BACKGROUND = new ResourceLocation("ftbsbc", "textures/gui/crook_jei_background.png");
    private static final Comparator<ItemWithChance> COMPARATOR = (a, b) -> (int)(b.chance() * 100.0 - a.chance() * 100.0);
    private final IDrawableStatic background;

    public CrookCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(BACKGROUND, 0, 0, 156, 78).setTextureSize(180, 78).build();
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends CrookRecipe> getRecipeClass() {
        return CrookRecipe.class;
    }

    public Component getTitle() {
        return new TextComponent("Crooking");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(CrookRecipe crookRecipe, IIngredients iIngredients) {
        iIngredients.setInputs(VanillaTypes.ITEM, Arrays.asList(crookRecipe.ingredient.m_43908_()));
        ArrayList<ItemWithChance> results = new ArrayList<ItemWithChance>(crookRecipe.results);
        results.sort(COMPARATOR);
        iIngredients.setOutputs(VanillaTypes.ITEM, crookRecipe.results.stream().map(e -> e.item()).collect(Collectors.toList()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, CrookRecipe crookRecipe, IIngredients iIngredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 4, 4);
        itemStacks.init(1, true, 4, 23);
        ArrayList<ItemWithChance> itemWithChance = new ArrayList<ItemWithChance>(crookRecipe.results);
        itemWithChance.sort(COMPARATOR);
        for (int i = 0; i < itemWithChance.size(); ++i) {
            itemStacks.init(2 + i, false, 27 + i % 7 * 18, 4 + i / 7 * 24);
        }
        itemStacks.set(iIngredients);
    }

    public void draw(CrookRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        super.draw((Object)recipe, matrixStack, mouseX, mouseY);
        ArrayList<ItemWithChance> itemWithWeights = new ArrayList<ItemWithChance>(recipe.results);
        itemWithWeights.sort(COMPARATOR);
        int row = 0;
        for (int i = 0; i < itemWithWeights.size(); ++i) {
            if (i > 0 && i % 7 == 0) {
                ++row;
            }
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(36 + i % 7 * 18), (double)(23.5f + (float)(row * 24)), 100.0);
            matrixStack.m_85841_(0.5f, 0.5f, 8000.0f);
            Gui.m_93208_((PoseStack)matrixStack, (Font)Minecraft.m_91087_().f_91062_, (String)(Math.round(itemWithWeights.get(i).chance() * 100.0) + "%"), (int)0, (int)0, (int)0xFFFFFF);
            matrixStack.m_85849_();
        }
    }
}

